function Y=update_Y(train_data,test_data,beta,b,lambda2,IFB)
% update Y by dynamic programming
index=unique(test_data.index);
max_taskno=max(test_data.taskno);
Y=zeros(size(test_data.index));
data_num=size(train_data.data,1)+size(test_data.data,1);
for i=index'
    num=sum(test_data.index==i);
    unlabel_data.data=test_data.data(test_data.index==i,:);
    unlabel_data.timeorder=test_data.timeorder(test_data.index==i);
    unlabel_data.taskno=test_data.taskno(test_data.index==i);
    [unlabel_data.timeorder,I]=sort(unlabel_data.timeorder,'descend');
    unlabel_data.data=unlabel_data.data(I,:);
    unlabel_data.taskno=test_data.taskno(I);
    petition_label=unique(train_data.label(train_data.index==i));
    label=zeros(num,1);
    % unlabel petitions 
    if(isempty(petition_label))
        for j=1:num
            taskno=unlabel_data.taskno(j);
            data=unlabel_data.data(j,:);
            label(j)=sign(data(IFB{taskno})*beta(IFB{taskno},taskno)+b(taskno));
            if(label(j)==-1)
                label(j+1:num)=-1;
                break;
            end
        end
        % unsucessful petitions
    else if (petition_label==-1)
        label(1:num)=-1;
        % sucessful petitions
        else
          for j=1:num
            taskno=unlabel_data.taskno(j);
            data=unlabel_data.data(j,:);
            if(taskno==max_taskno)
                label(j)=sign(data(IFB{taskno})*beta(IFB{taskno},taskno)+b(taskno));
            else
                successor_label=label(unlabel_data.taskno==taskno+1);
            value1=max(0,1-data(IFB{taskno})*beta(IFB{taskno},taskno)-b(taskno));
            value2=max(0,1+data(IFB{taskno})*beta(IFB{taskno},taskno)+b(taskno))-lambda2*sum(successor_label==1);
            if(value1>value2)
            label(j)=-1;
            else
                label(j)=1;
            end
            end
            if(label(j)==-1)
                label(j+1:num)=-1;
                break;
            end
          end  
        end        
    end
 Y(test_data.index==i)=label(I);
end
end